% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Pxy}
\alias{Pxy}
\title{A function to compute the mean proximity between
persons of different groups (Pxy)}
\usage{
Pxy(x, d = NULL, fdist = 'l', spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{d}{- a matrix with the distances between spatial
units centroids}

\item{fdist}{- the method used for distance calculations:
'l' for linear (by default) and 'e' for exponential function.}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A matrix with Pxx values
}
\description{
The Pxy index computes the mean distance between
the persons of different groups.  The function can be used in
two ways: by providing a distance matrix, or a geographic source
(spatial object or shape file) wich will be used to compute the
matrix within the function.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
dist<- distance(GreHSize)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

Pxy(x, d = dist)

Pxy(x, spatobj = GreHSize)

Pxy(x, folder = foldername, shape = shapename)
}
\references{
White M. J. (1988) \emph{The Measurement of
Spatial Segregation}.
American Journal of Sociology, 88, p. 1008-1019
}
\seealso{
Absolute Clustering Index: \code{\link{ACL}}

Other proximity measures: \code{\link{Pxx}} ,
\code{\link{Poo}}, \code{\link{SP}}
}

