% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\title{Design Generator for Three Models}
\usage{
design(model = c("dropout", "proportional", "interference"), n, opt, t,
  p, ..., max_iter = 40)
}
\arguments{
\item{model}{an model indicator, must be one of 'dropout', 'proportional', or 'interference'.}

\item{n}{Positive Integer, total number of observations needed.}

\item{opt}{Integer. optimal criterion indicator, opt = 0 means D-opt, opt = 1 means A-opt}

\item{t}{Positive interger,number or levels of treatment, the default coding is integer from 1 to t}

\item{p}{Numeric, number of periods for crossover model or number of blocks for intereference model}

\item{...}{other necessary control parameters required by specific model
For crossover with dropout, \code{drop}, a numeric vector of dropout mechanism
For crossover proportional, \code{lambda},value of proportion cofficient in proportional model
and \code{sigma}, assumed covariance matrix.
For interference model, \code{sigma}, assumed covariance matrix.}

\item{max_iter}{a positive integer. Controls maximum iteration time of exchange. Default is 40.}
}
\value{
A S3 object of one of classes 'dropout', 'proportional' or 'interference'.
    \item{model}{the model name}
    \item{n}{total number of observations of exact design}
    \item{opt}{optimal criterion}
    \item{t}{number of levels of treaments}
    \item{p}{number of periods or plots in a block}
    \item{...}{other inputs}
    \item{initial_design}{a randomly chosen design as a starting point for
        newton's method}
    \item{exact_design}{an exact design rounded from approximate design}
    \item{approx_design}{optimal approximate design}
    \item{verify_equivalence}{result of general equivalence theorem, the last
        entry is the value of directional derivative}
    \item{time}{computing time for approximate design}
}
\description{
Construct optimal approximate designs as well as efficient exact designs for
crossover model with subject dropout, crossover model with proportional residual
effect, and interference model.
}
\examples{
# NOTE: max_iter is usually set to 40. 
# Here max_iter = 5 is for demenstration only.
# crossover dropout model
## D-optimal

example1 <- design('dropout',10,0,3,3,drop=c(0,0,0.5), max_iter = 5)
summary(example1)
eff(example1) # efficiency from rounding
effLB(example1) # obtain lower bound of efficiency

## A-optimal
design('dropout',10,1,3,3,drop=c(0,0,0.5), max_iter = 5)


# proportional model
## D-optimal
design('proportional',10,0,3,3, sigma = diag(1,3),tau = matrix(sqrt(1+3),
    nrow=3, ncol=1),lambda = 0.2, max_iter = 5)

## A-optimal
design('proportional',10,1,3,3, sigma = diag(1,3), tau = matrix(sqrt(1+3),
    nrow=3, ncol=1),lambda = 0.2, max_iter = 5)


# interference model
## D-optimal
design('interference',10,0,3,3, sigma = diag(1,3), max_iter = 5)

## A-optimal
design('interference',10,1,3,3, sigma = diag(1,3), max_iter = 5)

}
\seealso{
\code{\link{eff}}, \code{\link{effLB}}, \code{\link{summary}}
}
