\name{draw_subcatchments_OCN}
\alias{draw_subcatchments_OCN}
\title{Draw subcatchment map from an Optimal Channel Network}
\usage{
draw_subcatchments_OCN(OCN, drawRiver = TRUE, colPalette = NULL)
}
\arguments{
\item{OCN}{List as produced by \code{\link{aggregate_OCN}}.}

\item{drawRiver}{if \code{TRUE}, draw the OCN on top of the subcatchment map.}

\item{colPalette}{Color palette used. Default is \code{c("#009900", "#FFFF00",  "#FF9900", "#FF0000", "#FF00FF",  "#9900CC", "#555555", "#BBBBBB")}. Only the first \code{n} colors are used, where \code{n} is the number of different colors needed (calculated via a greedy coloring algorithm). \code{colPalette} accepts both functions creating color palettes and vectors of colors (see examples); in the latter case, the length of the vector cannot be lower than \code{n} (\code{n} cannot be predicted a priori, but generally 6 colors should suffice).}
}
\value{
No output is returned.
}
\description{
Function that draws a map of subcatchments generated by the aggregation process on the OCN.
}
\examples{
# 1a) aggregate a 20x20 OCN , use thrA = 5 pixels
# and draw subcatchments with default color palette
OCN <- aggregate_OCN(landscape_OCN(OCN_20), thrA = 5)
draw_subcatchments_OCN(OCN, drawRiver = TRUE)

# 1b) same as above, but define color palette with a function
draw_subcatchments_OCN(OCN, drawRiver = TRUE, colPalette = rainbow)

# 1c) same as above, but define color palette with a vector of colors
draw_subcatchments_OCN(OCN, drawRiver = TRUE, colPalette = hcl.colors(6, "Dark 3"))

}
