% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateReport.R
\name{GenerateReport}
\alias{GenerateReport}
\title{Generate Report}
\usage{
GenerateReport(featuredata = NULL, sampledata = NULL,
  metabolitedata = NULL, normmeth = list(method1 = c("nomis"), method2 =
  c("ccmn"), method3 = c("ruv2")), factorOI = NULL, covars = NULL,
  gfactor = NULL, missingvals = c("knn", "replace", "none"),
  logTrans = TRUE, k = NULL, fitintercept = TRUE, isvec = NULL,
  qcmets = NULL, rlsc.sampledata = NULL, ccmn.factor = NULL,
  volcano.yrange = NULL, scaling.refvec = NULL,
  reportName = "General_Report", ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.}

\item{sampledata}{A dataframe with sample information matching featuredata.}

\item{metabolitedata}{A dataframe with metabolite information matching featuredata.}

\item{normmeth}{A list of up to 3 normalisation methods, for combined methods, the list should consist of
vector with entries corresponding in order to the 2 methods to beused jointly.}

\item{factorOI}{factor of interest to be used, should correpond to column number or 
column name in sampledata corresponding to the factor of interest for the analysis.}

\item{covars}{names of the other covariates to be included when fitting the linear 
model for biomarker identification. Should correspond to column name in sampledata}

\item{gfactor}{A vector indicating the groups that need to be explored in the plots}

\item{missingvals}{The method to be used for removing missing values. Should be either "knn" or "replace".}

\item{logTrans}{A logical indication whether the data is to be log transformed.}

\item{k}{k Number of factors of unwanted variation to be included in the
"\code{ruv}" models.}

\item{fitintercept}{A logical indication whether an intercept component should be fitted in the linear model.}

\item{isvec}{A vector of internal standards to be used with the method
"\code{is}".}

\item{qcmets}{A vector indicating which metabolites should be used as the
internal, external standards or other quality control metabolites 
in the "\code{ruv}" models, or as multiple internal
standards in the "\code{ccmn}" and "\code{nomis}" methods.}

\item{rlsc.sampledata}{For the "\code{rlsc}" method, a dataframe that contains sample specific information. 
Unique sample names should be provided as row names. For this function, 
this should have, the batch number, the class and the run order, 
with column names 'batch', 'class' and 'order' respectively. 
For the QCs samples, 'class' should be allocated as 0.}

\item{ccmn.factor}{For the ccmn method. A vector describing biological factors.}

\item{volcano.yrange}{In the volcano plot, a numeric for the maximum y value (scale of y-axis is -log(p-value)), can only
be set to a value as big as the maximum y-value in the plots.}

\item{scaling.refvec}{A reference vector for the scaling method}

\item{reportName}{The name that should be used to save the report.}

\item{...}{Arguments to be passed onto other methods.}
}
\description{
Generates an interactive report based on basic user input. The user can choose up to 3 normalisation methods that will
be compared to the unadjusted data using various diagnostics to assess the normalisation. Guidance on choosing criteria 
is also provided.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
