% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cuestas_Garratt_unit_root.R
\name{Cuestas_Garratt_unit_root}
\alias{Cuestas_Garratt_unit_root}
\title{Cuestas and Garratt(2011) nonlinear unit root test function}
\usage{
Cuestas_Garratt_unit_root(x, max_lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{max_lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC, if 3 t-stat significance}
}
\value{
Model Estimated model

Selected lag the lag order

Test Statistic the value of the test statistic

CV Critical Values
}
\description{
This function allows you to make Cuestas and Garratt(2011) nonlinear unit root test
}
\examples{

x <- rnorm(1000)
Cuestas_Garratt_unit_root(x,max_lags=6,lsm=3)

y <- cumsum(rnorm(1000))
Cuestas_Garratt_unit_root(y,max_lags=12,lsm=2)

data(IBM)
Cuestas_Garratt_unit_root(IBM,max_lags=3,lsm=1)


}
\references{
Cuestas, J. C., & Garratt, D. (2011). Is real GDP per capita a stationary process? Smooth transitions, nonlinear trends and unit root testing. Empirical Economics, 41(3), 555-563.



Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
