% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C45ensembles.R
\name{C45ensembles}
\alias{C45ensembles}
\alias{C45iteratedVotingFilter}
\alias{C45iteratedVotingFilter.default}
\alias{C45iteratedVotingFilter.formula}
\alias{C45robustFilter}
\alias{C45robustFilter.default}
\alias{C45robustFilter.formula}
\alias{C45votingFilter}
\alias{C45votingFilter.default}
\alias{C45votingFilter.formula}
\title{Classical Filters based on C4.5}
\usage{
\method{C45robustFilter}{formula}(formula, data, ...)

\method{C45robustFilter}{default}(x, classColumn = ncol(x), ...)

\method{C45votingFilter}{formula}(formula, data, ...)

\method{C45votingFilter}{default}(x, nfolds = 10, consensus = FALSE,
  classColumn = ncol(x), ...)

\method{C45iteratedVotingFilter}{formula}(formula, data, ...)

\method{C45iteratedVotingFilter}{default}(x, nfolds = 10, consensus = FALSE,
  classColumn = ncol(x), ...)
}
\arguments{
\item{formula}{A formula describing the classification variable and the attributes to be used.}

\item{data, x}{Data frame containing the tranining dataset to be filtered.}

\item{...}{Optional parameters to be passed to other methods.}

\item{classColumn}{Positive integer indicating the column which contains the
(factor of) classes. By default, the last column is considered.}

\item{nfolds}{Number of folds in which the dataset is split.}

\item{consensus}{Logical. If TRUE, consensus voting scheme is used. If
FALSE, majority voting scheme is applied.}
}
\value{
An object of class \code{filter}, which is a list with seven components:
\itemize{
   \item \code{cleanData} is a data frame containing the filtered dataset.
   \item \code{remIdx} is a vector of integers indicating the indexes for
   removed instances (i.e. their row number with respect to the original data frame).
   \item \code{repIdx} is a vector of integers indicating the indexes for
   repaired/relabelled instances (i.e. their row number with respect to the original data frame).
   \item \code{repLab} is a factor containing the new labels for repaired instances.
   \item \code{parameters} is a list containing the argument values.
   \item \code{call} contains the original call to the filter.
   \item \code{extraInf} is a character that includes additional interesting
   information not covered by previous items.
}
}
\description{
Ensembled-based filters that use C4.5 classifier to remove label noise from a dataset as a
preprocessing step of classification. For more information, see 'Details' and
'References' sections.
}
\details{
Full description of the methods can be looked up in the provided reference. Notice that C4.5 is used as
base classifier instead of TILDE, since a standard attribute-value classification framework
is considered (instead of the ILP classification approach of the reference).

\code{C45robustFilter} builds a C4.5 decision tree from the training data, and then
removes those instances misclassfied by this tree. The process is repeated until no instances are removed.

\code{C45votingFilter} splits the dataset into \code{nfolds} folds, building and testing a C4.5 tree on every
combination of \code{nfolds}-1 folds. Thus \code{nfolds}-1 votes are gathered
for each instance. Removal is carried out by majority or consensus voting schemes.

\code{C45iteratedVotingFilter} somehow combines the two previous filter, since
it iterates \code{C45votingFilter} until no more noisy instances are removed.
}
\note{
By means of a message, the number of noisy
instances removed is displayed in the console.
}
\examples{
# Next example is not run in order to save time
\dontrun{
data(iris)
out1 <- C45robustFilter(Species~.-Sepal.Length, iris)
# We fix a seed since next two functions create partitions of data for the ensemble
set.seed(1)
out2 <- C45votingFilter(iris, consensus = TRUE)
out3 <- C45iteratedVotingFilter(Species~., iris, nfolds = 5)
print(out1)
print(out2)
print(out3)
identical(out1$cleanData,iris[setdiff(1:nrow(iris),out1$remIdx),])
identical(out2$cleanData,iris[setdiff(1:nrow(iris),out2$remIdx),])
identical(out3$cleanData,iris[setdiff(1:nrow(iris),out3$remIdx),])
}
}
\references{
Verbaeten S. (2002, December): Identifying mislabeled training examples in ILP classification
problems, in \emph{Proc. 12th Belgian-Dutch Conf. Mach. Learn.}, Utrecht, The Netherlands, pp. 71-78.
}

