% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_data_functions.R
\name{read_matlab_raster_data}
\alias{read_matlab_raster_data}
\title{Reads MATLAB raster data}
\usage{
read_matlab_raster_data(
  matlab_raster_file_name,
  sampling_interval_width = 1,
  zero_time_bin = NULL,
  add_sequential_trial_numbers = FALSE
)
}
\arguments{
\item{matlab_raster_file_name}{A character string specifying the file name,
including the full path to a raster data in MATLAB .mat files.}

\item{sampling_interval_width}{A number specifying how successive time bins
will be labeled The default value of 1 means that points will be labeled as
successive integers; i.e., time.1_2, time.2_3, etc. If this value was set
to a larger number, then time points will be specified at the given
sampling width. From example, if sampling_width is set to 10, then the time
labels would be time.1_10, time.10_20, etc. This is useful if the data is
sampled at a particular rate (e.g., if the data is sampled at 500Hz, one
might want to use sampling_interval_width = 2, so that the times listed on
the raster column names are in milliseconds).}

\item{zero_time_bin}{A number specifying the time bin that should be marked
as time 0. The default (NULL value) is to use the first bin as time 1.}

\item{add_sequential_trial_numbers}{A Boolean specifying one should add a
variable to the data called 'trial_number' that has sequential trial. These
trials numbers are needed for data that was recorded simultaneously so that
trials can be aligned across different sites.}
}
\value{
Returns a data frame of data in \verb{raster format} (i.e., with class
\code{raster_data}). Data that is in \verb{raster format} as the following variables:
\enumerate{
\item \code{labels.XXX}  These variables contain labels of which experimental conditions were shown on a given trial.
\item \code{time.XXX_YYY}  These variables contain the data for a given time, XXX is
the start time of the data in a particular bin and YYY is the end time.
\item \code{site_info.XXX} These variables contain additional meta data about the site.
\item \code{trial_number} This variable specifies a unique number for each row
indicating which trial a given row of data came from.
}

For more details on \verb{raster format} data see the vignette:
\code{vignette("data_formats", package = "NeuroDecodeR")}
}
\description{
Reads MATLAB data in raster format into an R raster_data format data frame. This
is similar to the general read_raster_data() function but it contains additional
arguments specific to MALTAB raster data.
}
\examples{


matlab_raster_file_name <- file.path(
  system.file("extdata", package = "NeuroDecodeR"),
  "Zhang_Desimone_7object_raster_data_small_mat",
  "bp1001spk_01A_raster_data.mat")

raster_data <- read_matlab_raster_data(matlab_raster_file_name)


}
\keyword{internal}
