% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCor.parallel.R
\name{dCor.parallel}
\alias{dCor.parallel}
\title{Parallelization of Distance Correlation for ROI Time Series}
\usage{
dCor.parallel(neurallist, cores)
}
\arguments{
\item{neurallist}{List of lists.
A list containing the time series list from all participants imported from the
\code{\link[NetworkToolbox]{convertConnBrainMat}} function}

\item{cores}{Number of computer processing cores to use when performing covariate analyses.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maximum amount of cores on your computer}
}
\value{
Returns a \emph{m} x \emph{m} x \emph{n} array corresponding to distance correlations
between ROIs (\emph{m} x \emph{m} matrix) for \emph{n} participants
}
\description{
Parallelizes the \code{\link[NetworkToolbox]{dCor}} function
for faster computation times
}
\examples{
\dontrun{
# Import time series data 
for(i in 1:5)

# Run distance correlation
dCor.parallel(mat.list, cores = 2)

}

}
\references{
Yoo, K., Rosenberg, M. D., Noble, S., Scheinost, D., Constable, R. T., & Chun, M. M. (2019).
Multivariate approaches improve the reliability and validity of functional connectivity and prediction of individual behaviors.
\emph{NeuroImage}, \emph{197}, 212-223.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
