% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.R
\name{reg}
\alias{reg}
\title{Regression Matrix}
\usage{
reg(data, family = c("binomial", "gaussian", "Gamma", "poisson"),
  symmetric = TRUE)
}
\arguments{
\item{data}{A dataset}

\item{family}{Error distribution to be used in the regression model.
Defaults to \code{"logistic"}.
Set to any family used in function \code{\link[stats]{family}}}

\item{symmetric}{Should matrix be symmetric?
Defaults to \code{TRUE}, taking the mean of the two edge weights
(i.e., \code{[i,j]} and \code{[j,i]})
Set to \code{FALSE} for asymmetric weights
(i.e., \code{[i,j]} does not equal \code{[j,i]})}
}
\value{
A matrix of fully regressed coefficients where
one variable is regressed over all others
}
\description{
Computes regression such that one variable is regressed over all other variables
}
\examples{
#binarize responses
psyb <- ifelse(neoOpen>=4, 1, 0)

#perform logistic regression
mat <- reg(psyb)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
