% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strength.R
\name{strength}
\alias{strength}
\title{Node Strength}
\usage{
strength(A)
}
\arguments{
\item{A}{An adjacency matrix of network data}
}
\value{
A vector of strength values for each node in the network.

If directed network, returns a list containing:

\item{inStrength}{Strength of incoming edges (pointing to the node)}

\item{outStrength}{Strength of outgoing edges (pointing away from the node)}

\item{relInf}{Relative degree of incoming and outgoing edges.
Positive values indicate more outgoing strength relative to incoming strength.
Negative values indicate more incoming strength relative to outgoing strength}
}
\description{
Computes strength of each node in a network
}
\examples{
#Undirected network
A <- TMFG(neoOpen)$A

str <- strength(A)

#Directed network
\dontrun{
dep <- depend(neoOpen)

Adep <- TMFG(dep, depend = TRUE)$A

str <- strength(Adep)
}

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52} 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
