% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpmIV.R
\name{cpmIV}
\alias{cpmIV}
\title{Connectome-based Predictive Modeling--Internal Validation}
\usage{
cpmIV(neuralarray, bstat, covar, thresh = 0.01, method = c("mean",
  "sum"), model = c("linear", "quadratic", "cubic"),
  corr = c("pearson", "spearman"), shen = FALSE, cores,
  progBar = TRUE)
}
\arguments{
\item{neuralarray}{Array from \code{\link{convertConnBrainMat}} function}

\item{bstat}{Behavioral statistic for each participant with neural data (a vector)}

\item{covar}{Covariates to be included in predicting relevant edges (\strong{time consuming}).
\strong{Must} be input as a list() (see examples)}

\item{thresh}{Sets an \strong{alpha} threshold for edge weights to be retained.
Defaults to .01}

\item{method}{Use "mean" or "sum" of edge strengths in the positive and negative connectomes.
Defaults to "mean"}

\item{model}{Regression model to use for fitting the data.
Defaults to "linear"}

\item{corr}{Correlation method for assessing the relatonship between the behavioral measure and edges between ROIs.
Defaults to "pearson".
Set to "spearman" for non-linear or monotonic associations}

\item{shen}{Are ROIs from Shen et al. 2013 atlas? Defaults to FALSE.
Set to TRUE for canonical networks plot}

\item{cores}{Number of computer processing cores to use when performing covariate analyses.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns a list containing: 

\item{results}{A matrix contaning: r coefficient (r), p-value (p-value),
mean absolute error (mae), root mean square error (rmse)}

\item{posMask}{Positive connectivity for input in
\href{https://bioimagesuiteweb.github.io/webapp/connviewer.html}{BioImage Suite Connectivity Viewer}}

\item{negMask}{Negative connectivity for input in
\href{https://bioimagesuiteweb.github.io/webapp/connviewer.html}{BioImage Suite Connectivity Viewer}}
}
\description{
Applies the Connectome-based Predictive Modeling approach to neural data.
This method predicts a behavioral statistic using neural connectivity from the sample.
\strong{Please cite Finn et al., 2015; Rosenberg et al., 2016; Shen et al., 2017}
}
\references{
Finn, E. S., Shen, X., Scheinost, D., Rosenberg, M. D., Huang, J., Chun, M. M., Papademetris, X., Constable, R. T. (2015).
Functional connectome fingerprinting: Identifying individuals using patterns of brain connectivity.
\emph{Nature Neuroscience}, \emph{18}, 1664-1671.
doi: \href{https://doi.org/10.1038/nn.4135}{10.1038/nn.4135}

Rosenberg, M. D., Finn, E. S., Scheinost, D., Papademetris, X., Shen, X., Constable, R. T., Chun, M. M. (2016).
A neuromarker of sustained attention from whole-brain functional connectivity.
\emph{Nature Neuroscience}, \emph{19}, 165-171.
doi: \href{https://doi.org/10.1038/nn.4179}{10.1038/nn.4179}

Shen, X. Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M., Papademetris, X., Constable, R. T. (2017).
Using connectome-based predictive modeling to predict individual behavior from brain connectivity.
\emph{Nature Protocols}, \emph{12}, 506-518.
doi: \href{https://doi.org/10.1038/nprot.2016.178}{10.1038/nprot.2016.178}

Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
Available from \url{https://github.com/taiyun/corrplot}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
