% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leverage.R
\name{leverage}
\alias{leverage}
\title{Leverage Centrality}
\usage{
leverage(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to TRUE.
Set to FALSE for unweighted measure of leverage centrality}
}
\value{
A vector of leverage centrality values for each node in the network
}
\description{
Computes leverage centrlaity of each node in a network
(the degree of connected neighbors; \strong{Please see and cite Joyce et al., 2010})
}
\examples{
A <- TMFG(neoOpen)$A

#Weighted
levW <- leverage(A)

#Unweighted
levU <- leverage(A, weighted = FALSE)

}
\references{
Joyce, K. E., Laurienti, P. J., Burdette, J. H., & Hayasaka, S. (2010).
A new measure of centrality for brain networks. 
\emph{PLoS One}, \emph{5} e12200.
doi: \href{https://doi.org/10.1371/journal.pone.0012200}{10.1371/journal.pone.0012200}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
