% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{cpmIV}
\alias{cpmIV}
\title{Connectome-based Predictive Modeling--Internal Validation}
\usage{
cpmIV(neuralarray, bstat, covar, thresh = 0.01, method = c("mean", "sum"),
  model = c("linear", "quadratic", "cubic"), corr = c("pearson",
  "spearman"), shen = FALSE, cores, progBar = TRUE)
}
\arguments{
\item{neuralarray}{Array from \emph{convertConnBrainMat} function}

\item{bstat}{Behavioral statistic for each participant with neural data (a vector)}

\item{covar}{Covariates to be included in predicting relevant edges (\strong{time consuming}).
\strong{Must} be input as a list() (see examples)}

\item{thresh}{Sets an \strong{alpha} threshold for edge weights to be retained.
Defaults to .01}

\item{method}{Use "mean" or "sum" of edge strengths in the positive and negative connectomes.
Defaults to "mean"}

\item{model}{Regression model to use for fitting the data.
Defaults to "linear"}

\item{corr}{Correlation method for assessing the relatonship between the behavioral measure and edges between ROIs.
Defaults to "pearson".
Set to "spearman" for non-linear or monotonic associations}

\item{shen}{Are ROIs from Shen et al. 2013 atlas? Defaults to FALSE.
Set to TRUE for canonical networks plot}

\item{cores}{Number of computer processing cores to use when performing covariate analyses.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns a list containing a matrix (correlation coefficient (r), p-value (p), Bayes Factor (BF), mean absolute error (mae), root mean square error (rmse)).
The list also contains the positive (posMask) and negative (negMask) masks, which can be visualized here: \url{http://bisweb.yale.edu/build/connviewer.html}
}
\description{
Applies the Connectome-based Predictive Modeling approach to neural data.
This method predicts a behavioral statistic using neural connectivity from the sample.
\strong{Please cite Finn et al., 2015; Rosenberg et al., 2016; Shen et al., 2017}
}
\references{
Finn, E. S., Shen, X., Scheinost, D., Rosenberg, M. D., Huang, J., Chun, M. M., Papademetris, X., Constable, R. T. (2015).
Functional connectome fingerprinting: Identifying individuals using patterns of brain connectivity.
\emph{Nature Neuroscience}, \emph{18}(11), 1664-1671.

Ly, A., Verhagen, A. J., & Wagenmakers, E.-J. (2016).
Harold Jeffreys's default Bayes factor hypothesis tests: Explanation, extension, and application in psychology.
\emph{Journal of Mathematical Psychology}, \emph{72}, 19-32.

Rosenberg, M. D., Finn, E. S., Scheinost, D., Papademetris, X., Shen, X., Constable, R. T., Chun, M. M. (2016).
A neuromarker of sustained attention from whole-brain functional connectivity.
\emph{Nature Neuroscience}, \emph{19}(1), 165-171.

Shen, X. Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M., Papademetris, X., Constable, R. T. (2017).
Using connectome-based predictive modeling to predict individual behavior from brain connectivity.
\emph{Nature Protocols}, \emph{12}(3), 506-518.

Wagenmakers, E. J., Verhagen, J., & Ly, A. (2016).
How to quantify the evidence for the absence of a correlation.
\emph{Behavior Research Methods}, \emph{48}(2), 413-426.

Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
Available from \url{https://github.com/taiyun/corrplot}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
