% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{MaST}
\alias{MaST}
\title{Maximum Spanning Tree}
\usage{
MaST(data, normal = FALSE, weighted = TRUE, depend = FALSE,
  na.data = c("pairwise", "listwise", "fiml", "none"))
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{weighted}{Should network be weighted?
Defaults to TRUE.
Set to FALSE to produce an unweighted (binary) network}

\item{depend}{Is network a dependency (or directed) network?
Defaults to FALSE.
Set TRUE to generate a MaST-filtered dependency network
(output obtained from the \emph{depend} function)}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
If normal is TRUE, then "pairwise" is used.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}
}
\value{
A sparse association matrix
}
\description{
Applies the Maximum Spanning Tree (MaST) filtering method
}
\examples{
weighted_MaSTnetwork<-MaST(neoOpen)


unweighted_MaSTnetwork<-MaST(neoOpen,weighted=FALSE)

}
\references{
Adapted from: \url{https://www.mathworks.com/matlabcentral/fileexchange/23276-maximum-weight-spanning-tree--undirected}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
