% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_dsd.R
\name{nd.dsd}
\alias{nd.dsd}
\title{Discrete Spectral Distance}
\usage{
nd.dsd(A, out.dist = TRUE, type = c("Adj", "Lap", "SLap", "NLap"))
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{type}{type of target structure. One of \code{"Adj","Lap","SLap","NLap"} as defined above.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times M-1)} matrix where each row is top-\eqn{M-1} vibrational spectra.}
}
}
\description{
Discrete Spectral Distance (DSD) is defined as the Euclidean distance between
the spectra of various matrices, such as adjacency matrix \eqn{A}(\code{"Adj"}),
(unnormalized) Laplacian matrix \eqn{L=D-A}(\code{"Lap"}),
signless Laplacian matrix \eqn{|L|=D+A}(\code{"SLap"}), or
normalized Laplacian matrix \eqn{\tilde{L}=D^{-1/2}LD^{-1/2}}.
}
\examples{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## Compute Distance Matrix and Visualize
output = nd.dsd(A, out.dist=FALSE)
image(output$D, main="two group case")

}
\references{
\insertRef{wilson_study_2008}{NetworkDistance}
}
