% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{plotTriangleHeatmap}
\alias{plotTriangleHeatmap}
\title{Plot a symmetric heatmap as a triangle}
\usage{
plotTriangleHeatmap(values, palette, vlim, mas, na.indices = NULL,
  na.col = "#bdbdbd", xaxt = NULL, plotModuleNames = TRUE, main = "",
  main.line = 0, plotLegend = TRUE, legend.main = "",
  legend.main.line = 1, xaxt.line = -0.5, maxt.line = 3,
  laxt.tck = 0.04, laxt.line = 2.5, legend.line = 0.1, lwd = 2,
  dryRun = FALSE)
}
\arguments{
\item{values}{values to plot on the heatmap.}

\item{palette}{color palette to interpolate over.}

\item{vlim}{range of values to use when mapping values to the \code{palette}.}

\item{mas}{ordered subset of the moduleAssignments vector.}

\item{na.indices}{indices of missing values on the x axis.}

\item{na.col}{color of missing values to plot.}

\item{xaxt}{character vector of names to print along the x axis.}

\item{plotModuleNames}{logical; if \code{TRUE} the names of the modules are
plotted along the x axis.}

\item{main}{title for the plot.}

\item{main.line}{the number of lines into the top margin at which the plot
title will be drawn.}

\item{plotLegend}{logical; if \code{TRUE} a legend is added to the right 
side of the plot.}

\item{legend.main}{title for the legend.}

\item{legend.main.line}{distance from the legend to render the legend 
title.}

\item{xaxt.line}{the number of lines into the margin at which the x axis 
labels will be drawn.}

\item{maxt.line}{the number of lines into the margin at which the module 
names will be drawn.}

\item{laxt.tck}{size of the ticks on the axis legend as a proportion
of the horizontal size of the plot window.}

\item{laxt.line}{the distance from the legend to render the legend axis 
labels, as multiple of \code{laxt.tck}.}

\item{legend.line}{the distance from the left of the plot to render the 
legend as a proportion of the horizontal size of the plot window.}

\item{lwd}{line width for borders.}

\item{dryRun}{logical; if \code{TRUE} only the axes and borders will be 
drawn.}
}
\description{
Plot a symmetric heatmap as a triangle
}

