% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_helper_net.r
\name{plot_ptn}
\alias{plot_ptn}
\title{A plot method for public transportation networks (PTNs).}
\usage{
plot_ptn(
  g,
  color.coding = NULL,
  color.scheme = rev(sequential_hcl(5)),
  legend = FALSE,
  ...
)
}
\arguments{
\item{g}{\code{\link{igraph}} object, network graph representing the public transportation network, vetrices represent stations, which are linked by an edge if there is a direct transfer between them}

\item{color.coding}{numeric vector with length equal to the number of network nodes}

\item{color.scheme}{character vector of length 5 indicating the \code{vertex.color}, default is \code{rev(sequential_hcl(5))}}

\item{legend}{logical indicating whether legend for color-coding should be added or not.}

\item{...}{further arguments to be passed to \code{\link{plot.igraph}}}
}
\value{
No return value
}
\description{
A plot method for public transportation networks (PTNs).
}
\examples{
data(ptnAth)
plot_ptn(ptnAth)

data(ptnGoe)
plot_ptn(ptnGoe)

}
\seealso{
Other network helper: 
\code{\link{analyze_ptn}()}
}
\concept{network helper}
