% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.r
\name{eff_dist}
\alias{eff_dijkstra}
\alias{eff_dist}
\alias{spd_dijkstra}
\title{Computation of effective path distance}
\usage{
eff_dist(p)

eff_dijkstra(p, start)

spd_dijkstra(p, start)
}
\arguments{
\item{p}{numeric matrix, representing the transition probability matrix for the network graph}

\item{start}{start of path}
}
\value{
A numeric matrix, representing the effective distance between all nodes in the network graph.
}
\description{
\code{eff_dist} computes the effective distance between all nodes in the network

\code{eff_dijkstra} computes the shortest effective paths using the dijkstra algorithm

\code{spd_dijkstra} computes the shortest paths using the dijkstra algorithm
}
\examples{
# compute effective shortest path distance
data(ptnAth)
require(igraph)
net <- igraph::as_adjacency_matrix(ptnAth, sparse=FALSE)
p <- net/rowSums(net)
eff <- eff_dist(p)

# compute shortest path distance
data(ptnAth)
athnet <- as_adj(ptnAth, sparse=FALSE)
spd <- spd_dijkstra(athnet, start=1)

# compare calculations with the one from igraph
spd_igraph <- igraph::distances(ptnAth, v=1, algorithm='dijkstra')
all(spd[[1]] == spd_igraph)

}
\references{
\itemize{
 \item Dijkstra, E. W. (1959): A note on two problems in connexion with graphs. Numerische Mathematik, 1, 269-271. <DOI: 10.1007/BF01386390>
 \item Brockmann, D. and Helbing, D. (2013): The hidden geometry of complex, network-driven contagion phenomena. Science, 342, 1337-1342. <DOI: 10.1126/science.1245200>
 \item Manitz, J. (2014): Statistical Inference for Propagation Processes on Complex Networks. Ph.D. thesis, Georg-August-University Goettingen. Verlag Dr. Hut, ISBN 978-3-8439-1668-4. Available online: \url{http://ediss.uni-goettingen.de/handle/11858/00-1735-0000-0022-5F38-B}.
}
}

