% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world-functions.R
\docType{methods}
\name{raster2world}
\alias{raster2world}
\alias{raster2world,RasterLayer,character-method}
\alias{raster2world,RasterStack,character-method}
\title{Convert a Raster* object into a worldMatrix or worldArray object}
\usage{
raster2world(raster, method)

\S4method{raster2world}{RasterLayer,character}(raster, method)

\S4method{raster2world}{RasterStack,character}(raster, method)
}
\arguments{
\item{raster}{RasterLayer or RasterStack object.}

\item{method}{"ngb" or "bilinear" for the resample method.}
}
\value{
WorldMatrix or worldArray object depending on the input \code{raster}.
        Patches value are retained from the \code{raster}.
}
\description{
Convert a RasterLayer object into a worldMatrix object or a RasterStack object
into a worldArray object.
}
\details{
See \code{help("worldMatrix-class")} or \code{help("worldArray-class")}
         for more details on the classes.

         The \code{raster} is resampled to match the coordinates system and
         resolution of a worldMatrix or worldArray using the chosen \code{method}. The
         extent will be bigger by 1 on the width and on the height.
}
\examples{
r1 <- raster(extent(c(0, 10, 0, 10)), nrows = 10, ncols = 10)
r1[]<-runif(100)
w1 <- raster2world(r1, method = "ngb")
plot(r1)
plot(w1)


}
\author{
Sarah Bauduin
}
