% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{nOf}
\alias{nOf}
\alias{nOf,matrix,numeric-method}
\title{N random \code{agents}}
\usage{
nOf(agents, n)

\S4method{nOf}{matrix,numeric}(agents, n)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          Matrix (`ncol` = 3) with the first column "`pxcor` and the second
          column `pycor` representing the `patches` coordinates and the
          third column `id`, or

          `AgentMatrix` object representing the moving `agents`, or

          Matrix (`ncol` = 2) with the first column `whoTurtles` and the
          second column `id`.
}\if{html}{\out{</div>}}}

\item{n}{Integer. Number of \code{patches} or \code{turtles} to select from \code{agents}.}
}
\value{
Matrix (\code{ncol} = 2, \code{nrow} = \code{n}) with the first column \code{pxcor}
and the second  column \code{pycor} representing the coordinates of the
selected patches from \code{agents}, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Matrix (`ncol` = 2) with the first column `pxcor`
    and the second  column `pycor` representing the coordinates of the
    selected `patches` from `agents`, `n` per individual "id", or

    `AgentMatrix` (`nrow` = `n`) representing the `turtles`
    selected from `agents`,

    Integer. Vector of `who` numbers for the selected `turtles` from
    `agents`, `n` per individual "id".
}\if{html}{\out{</div>}}
}
\description{
Report \code{n} \code{patches} or \code{turtles} randomly selected among \code{agents}.
}
\details{
\code{n} must be less or equal the number of \code{patches}
or \code{turtles} in \code{agents}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If `agents` is a matrix with `ncol` = 3, the selection of `n`
     random `patches` is done per individual "id". The order of the `patches`
     coordinates returned follow the order of "id".
     If `agents` is a matrix (`ncol` = 2) with columns `whoTurtles` and
     `id`, the selection of `n` random `turtles` (defined by their `whoTurtles`)
     is done per individual "id". The order of the `who` numbers returned
     follow the order of "id".
}\if{html}{\out{</div>}}
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
pSelect <- nOf(agents = patches(w1), n = 5)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
tSelect <- nOf(agents = t1, n = 2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#n-of}
}
\author{
Sarah Bauduin
}
