% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{minNof}
\alias{minNof}
\alias{minNof,matrix,numeric,worldMatrix,missing-method}
\alias{minNof,matrix,numeric,worldArray,character-method}
\alias{minNof,agentMatrix,numeric,missing,character-method}
\title{N agents with minimum}
\usage{
minNof(agents, n, world, var)

\S4method{minNof}{matrix,numeric,worldMatrix,missing}(agents, n, world)

\S4method{minNof}{matrix,numeric,worldArray,character}(agents, n, world, var)

\S4method{minNof}{agentMatrix,numeric,missing,character}(agents, n, var)
}
\arguments{
\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{n}{Integer.}

\item{world}{WorldMatrix or worldArray object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are patches and the \code{world} is a
worldMatrix object, \code{var} must not be provided. If
\code{agents} are patches and the \code{world} is a worldArray
object, \code{var} is the name of the layer to use to define the patches
values. If \code{agents} are turtles, \code{var} is one of
the turtles' variable and can be equal to \code{"xcor"},
\code{"ycor"}, any of the variables created when turtles were created,
as well as any variable created using \code{turtlesOwn()}.}
}
\value{
Matrix (ncol = 2, nrow = \code{n}) with the first column "pxcor" and
        the second column "pycor" representing the coordinates of the \code{n}
        patches among the \code{agents} which have their variable values among
        the minimum values among the
        \code{agents}, or

        AgentMatrix of length \code{n} representing the turtles among the
        \code{agents} which
        have their \code{var} values among the minimum values among the \code{agents}.
}
\description{
Report the \code{n} patches or turtles among \code{agents} which have their variable
among the minimum values.
}
\details{
\code{world} must not be provided if \code{agents} are turtles.

         If there is a tie that would make the number of returned patches or turtles larger
         than \code{n}, it is broken randomly.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                  data = sample(1:10, size = 25, replace = TRUE))
plot(w1)
p1 <- minNof(agents = patches(w1), n = 6, world = w1)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    heading = sample(1:5, size = 10, replace= TRUE))
t2 <- minNof(agents = t1, n = 5, var = "heading")


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#min-n-of}
}
\author{
Sarah Bauduin
}
