% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netint.R
\name{WAP.int}
\alias{WAP.int}
\title{Weighted Average Per-class (WAP) network integration}
\usage{
WAP.int(m, align = FALSE, logint = FALSE, ...)
}
\arguments{
\item{m}{a numeric vector with the values of the metric used to compute the alpha
coefficients. It could be e.g. AUC values.}

\item{align}{logic. If TRUE the numeric matrices passed as arguments are aligned
according to the function align.networks (def: FALSE).}

\item{logint}{logic. If TRUE m is log transformed: -log(1-m), otherwise a linear
integration is performed (def: FALSE).}

\item{...}{a list of numeric matrices. These must be named matrices representing
adjacency matrices of the networks. Matrices may have different dimensions,
but corresponding elements in different matrices must have the same name.}
}
\value{
A list with two elements:
\itemize{
\item WAP : the matrix resulting from WAP
\item alpha : a numeric vector with the weight coefficients of the networks
}
}
\description{
It performs the WAP integration between networks:
\loadmathjax
\mjsdeqn{\bar{w}_{ij}(k) = \sum_{d = 1}^n \alpha^d(k) w_{ij}^d}
where
\mjsdeqn{\alpha^d(k) = \frac{1}{\sum_{j=1}^n M^j(k)} M^d(k)}
and \mjseqn{M^d(k)} is a suitable accuracy metrics for class k on network d.
The metrics could be, e.g. the AUC or the precision at a given recall.
Note that this function puts more weight (alpha parameter) for networks with
associated larger M.
}
\examples{
# Create three example networks of different size
set.seed(123);
A1 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A1[lower.tri(A1)] = t(A1)[lower.tri(A1)];
diag(A1) <- 0;
rownames(A1) <- colnames(A1) <- sample(LETTERS, 10);

A2 <- matrix(runif(49, min = 0, max = 1), nrow = 7);
A2[lower.tri(A2)] = t(A2)[lower.tri(A2)];
diag(A2) <- 0;
rownames(A2) <- colnames(A2) <- rownames(A1)[1:7];

A3 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A3[lower.tri(A3)] = t(A3)[lower.tri(A3)];
diag(A3) <- 0;
rownames(A3) <- colnames(A3) <- c(rownames(A1)[1:5], c("A", "B", "Z", "K", "Q"));

# Create random vector of accuracy metrics
m <- runif(3, min = 0, max = 1);

# Integrate networks using Weighted Average Per-class (WAP) method
A_int <- WAP.int(m, align=TRUE, logint=FALSE, A1, A2, A3);
}
