% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_network_plot.R
\name{multiple.network.plot}
\alias{multiple.network.plot}
\title{Plots networks for multiple conditions}
\usage{
multiple.network.plot(netfacs.graphs, sig.level = 0.01, sig.nodes.only = FALSE)
}
\arguments{
\item{netfacs.graphs}{List of network objects resulting from
\code{\link{netfacs_multiple}} function or
\code{\link{multiple.netfacs.network}} function}

\item{sig.level}{Numeric between 0 and 1. P value used to determine whether
nodes are significant. Default = 0.01.}

\item{sig.nodes.only}{Logical. Should only nodes that were significant in _at
least_ one of the networks be included in the plots? Default = FALSE.}
}
\value{
Function returns a \code{\link{ggraph}} plot showing connections
  between nodes in the different networks. Elements that are significantly
  more likely to occur than expected are large, non-significant elements are
  small, and absent elements are absent.
}
\description{
The function takes multiple network objects and plots them next to each other
while keeping the element positions etc constant. Uses \code{\link{ggraph}}
function
}
\examples{
data(emotions_set)
emo.faces <- netfacs_multiple(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  duration = NULL,
  ran.trials = 10, # only for example
  control = NULL,
  random.level = NULL,
  combination.size = 2
)

emo.nets <- multiple.netfacs.network(emo.faces, min.count = 5)
multiple.network.plot(emo.nets)
}
