% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myFUN.R
\name{reject_set}
\alias{reject_set}
\title{Finds the rejection set in a multiple testing problem}
\usage{
reject_set(locfdr, level = 0.1)
}
\arguments{
\item{locfdr}{The vector of local false discovery rates (actual or estimated) corresponding to a family of hypotheses.}

\item{level}{The level at which the false discovery rate is to be controlled. Should ideally be a scalar in \eqn{[0,1]}.}
}
\value{
A vector of 1s and 0s with 1s indicating the hypotheses which are to be rejected.
}
\description{
This function accepts a vector of local false discovery rates from a family of hypotheses
and a level parameter, to compute the rejection set.
}
\details{
The problem of optimal inference in multiple hypotheses testing has been widely studied in literature. In particular, this function adopts the framework and algorithm proposed in Basu et al. See \strong{References}.
}
\examples{

x=cbind(runif(1000),runif(1000))
n=1000
atoms=c(-2,0,2)
probs=c(0.48,0.04,0.48)
variances=c(1,16,1)
sx=c(-3,1.5,1.5)
stdata=makedata(n,x,sx,atoms,probs,variances)
### Obtain the rejection set ###
reject=reject_set(stdata$lo)
}
\references{
Basu, P., Cai, T.T., Das, K. and Sun, W., 2018. Weighted false discovery rate control in large-scale multiple testing. Journal of the American Statistical Association, 113(523), pp.1172-1183.

Deb, N., Saha, S., Guntuboyina, A. and Sen, B., 2018. Two-component Mixture Model in the Presence of Covariates. arXiv preprint arXiv:1810.07897.
}
