% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PM.matrix}
\alias{PM.matrix}
\title{Partial Moment Matrix}
\usage{
PM.matrix(LPM_degree, UPM_degree, target, variable, pop_adj, norm = FALSE)
}
\arguments{
\item{LPM_degree}{numeric; lower partial moment degree (0 = freq, 1 = area).}

\item{UPM_degree}{numeric; upper partial moment degree (0 = freq, 1 = area).}

\item{target}{numeric vector; thresholds for each column (defaults to colMeans).}

\item{variable}{numeric matrix or data.frame.}

\item{pop_adj}{logical; TRUE adjusts population vs. sample moments.}

\item{norm}{logical; \code{FALSE} (default) if TRUE, each of the four quadrant partial-moment matrices (cupm, dupm, dlpm, clpm) is normalized cell-wise so that their sum at each position is 1. The covariance matrix is then recomputed from those normalized quadrants.}
}
\value{
A list with elements $cupm, $dupm, $dlpm, $clpm and $cov.matrix.
}
\description{
Builds a list containing all four quadrant partial‑moment matrices
  (CUPM, DUPM, DLPM, CLPM) plus the overall covariance matrix.
}
\examples{
  set.seed(123)
  A <- cbind(rnorm(100), rnorm(100), rnorm(100))
  PM.matrix(1, 1, NULL, A, TRUE)
}
\references{
Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
