% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMA_optim.R
\name{NNS.ARMA.optim}
\alias{NNS.ARMA.optim}
\title{NNS ARMA Optimizer}
\usage{
NNS.ARMA.optim(variable, training.set, seasonal.factor,
  negative.values = FALSE, obj.fn = expression(sum((predicted -
  actual)^2)), objective = "min", linear.approximation = TRUE,
  depth = 1, print.trace = TRUE, ncores = NULL, subcores = NULL)
}
\arguments{
\item{variable}{a numeric vector.}

\item{training.set}{numeric; \code{NULL} (defualt) Sets the number of variable observations}

\item{seasonal.factor}{integers; Multiple frequency integers considered for \link{NNS.ARMA} model, i.e. \code{(seasonal.factor = c(12, 24, 36))}}

\item{negative.values}{logical; \code{FALSE} (default) If the variable can be negative, set to
\code{(negative.values = TRUE)}.}

\item{obj.fn}{expression; \code{expression(sum((predicted - actual)^2))} (default) Sum of squared errors is the default objective function.  Any \code{expression()} using the specific terms \code{predicted} and \code{actual} can be used.}

\item{objective}{options: ("min", "max") \code{"min"} (default) Select whether to minimize or maximize the objective function \code{obj.fn}.}

\item{linear.approximation}{logical; \code{TRUE} (default) Uses the best linear output from \code{NNS.reg} to generate a nonlinear and mixture regression for comparison.  \code{FALSE} is a more exhaustive search over the objective space.}

\item{depth}{integer; \code{depth = 1} (default) Sets the level from which further combinations are generated containing only members from prior level's best \code{seasonal.factors}.}

\item{print.trace}{logical; \code{TRUE} (defualt) Prints current iteration information.  Suggested as backup in case of error, best parameters to that point still known and copyable!}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized procedure. If NULL (default), the number of cores to be used is equal to half the number of cores of the machine.}

\item{subcores}{integer; value specifying the number of cores to be used in the parallelized procedure in the subroutine \link{NNS.ARMA}.  If NULL (default), the number of cores to be used is equal to half the number of cores of the machine - 1.}
}
\value{
Returns a list containing:
\itemize{
\item{\code{$period}} a vector of optimal seasonal periods
\item{\code{$weights}} the optimal weights of each seasonal period between an equal weight or NULL weighting
\item{\code{$obj.fn}} the minimum objective function value
\item{\code{$method}} the method identifying which \link{NNS.ARMA} method was used.
}
}
\description{
Wrapper function for optimizing any combination of a given \code{seasonal.factor} vector in \link{NNS.ARMA}.  Minimum sum of squared errors (forecast-actual) is used to determine optimum across all \link{NNS.ARMA} methods.
}
\note{
The number of combinations will grow prohibitively large, they should be kept to a minimum when \code{(method = "comb")}.

\code{seasonal.factor} containing an element too large will result in an error.  Please reduce the maximum \code{seasonal.factor}.
}
\examples{

## Nonlinear NNS.ARMA period optimization using 2 yearly lags on AirPassengers monthly data
\dontrun{
nns.optims <- NNS.ARMA.optim(AirPassengers[1:132], training.set = 120,
seasonal.factor = seq(12, 24, 6))
}

## Then use optimal parameters in NNS.ARMA to predict 12 periods in-sample
\dontrun{
NNS.ARMA(AirPassengers, h=12, training.set=132,
seasonal.factor = nns.optims$periods, method = nns.optims$method)
}

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
