% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Co_PM_cor.R
\name{NNS.cor.hd}
\alias{NNS.cor.hd}
\title{NNS Co-Partial Moments Higher Dimension Correlation}
\usage{
NNS.cor.hd(x, plot = FALSE, independence.overlay = FALSE)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{plot}{logical; \code{FALSE} (default) Generates a 3d scatter plot with regression points using \link{plot3d}.}

\item{independence.overlay}{logical; \code{FALSE} (default) Creates and overlays independent \link{Co.LPM} and \link{Co.UPM} regions to visually reference the difference in dependence from the data.frame of variables being analyzed.  Under independence, the light green and red shaded areas would be occupied by green and red data points respectively.}
}
\value{
Returns multivariate nonlinear correlation coefficient
}
\description{
Determines higher dimension correlation coefficients based on degree 0 co-partial moments.
}
\examples{
set.seed(123)
x <- rnorm(1000) ; y <- rnorm(1000) ; z <- rnorm(1000)
A <- data.frame(x, y, z)
NNS.cor.hd(A, plot = TRUE, independence.overlay = TRUE)
}
\references{
Viole, F. (2016) "Beyond Correlation: Using the Elements of Variance for Conditional Means and Probabilities"  \url{http://ssrn.com/abstract=2745308}.
}
\author{
Fred Viole, OVVO Financial Systems
}
