% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multivariate_Regression.R
\name{VN.M.reg}
\alias{VN.M.reg}
\title{VN Multivariate Regression (INTERNAL CALL FOR \link{VN.reg})}
\usage{
VN.M.reg(B, y, order = 1, s.t.n = 0.9, n.best = NULL, type = "XONLY",
  point.est = NULL, plot = FALSE, residual.plot = TRUE,
  location = location)
}
\arguments{
\item{B}{Complete dataset of independent variables (IV) in matrix form.}

\item{y}{Dependent variable (DV).}

\item{order}{Controls the number of the \code{VN.reg}.  Defaults to \code{order=1}.}

\item{s.t.n}{Signal to noise parameter, sets the threshold of \code{VN.dep} which reduces \code{"order"} when \code{order=NULL}.  Defaults to 0.9 to ensure high dependence for higher \code{"order"} and endpoint determination.}

\item{n.best}{Sets the number of closest regression points to use in kernel weighting.  Defaults to number of independent variables.}

\item{type}{Controls the partitioning in \code{VN.reg}.  Defaults to \code{type="XONLY"} for IV based partitioning.   \code{type=NULL} for both IV and DV partitioning.}

\item{point.est}{Generates a fitted value of \code{y} for a vector or matrix of IV coordinates.}

\item{plot}{Generates a 3d scatter plot with regression points using \link{plot3d}}

\item{residual.plot}{Generates a \code{matplot} for Y.hat and Y}

\item{location}{Sets the location of the legend}
}
\value{
Returns the values: \code{"Fitted"} for only the fitted values of the DV; \code{"regression.points"} provides the points for each IV used in the regression equation for the given order of partitions; \code{"rhs.partitions"} returns the partition points for each IV; \code{"partition"} returns the DV, quadrant assigned to the observation and fitted value, and  \code{"Point.est"} for predicted values.
}
\description{
Called by \code{VN.reg} for multivariate regression analysis.
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{multiple}
\keyword{nonlinear}
\keyword{regression}

