% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classifier.R
\name{VN.class}
\alias{VN.class}
\title{VN Classifier}
\usage{
VN.class(x, y, threshold = 0, order = NULL, point.est = NULL,
  location = "top", print.values = FALSE, print.equation = FALSE,
  plot = TRUE, clean.method = NULL, dep.order = NULL)
}
\arguments{
\item{x}{Complete dataset in matrix form.}

\item{y}{Column of data to be classified.}

\item{threshold}{Sets the correlation threshold for independent variables.  Defaults to 0.}

\item{order}{Controls the number of partial moment quadrant means.  Users are encouraged to try different \code{order=} settings.  \code{order='max'} will use maximum suggested possible order based on number of observations.}

\item{point.est}{Returns the fitted value for any value of the independent variable.  Use a vector of values for independent varaiables to return the multiple regression fitted value.}

\item{location}{Sets the legend location within the plot}

\item{print.values}{Defaults to FALSE, set to TRUE in order to return all fitted values for independent variable}

\item{print.equation}{Defaults to FALSE, set to TRUE in order to return the local coefficients}

\item{plot}{To plot regression or not.  Defaults to TRUE.}

\item{clean.method}{Method to handle missing or NA values.  'omit' uses \code{\link{complete.cases}} function on data while 'zero' replaces missing data with 0 value.  Defaults to NULL assuming user has cleaned data prior to analyzing.}

\item{dep.order}{Sets the internal order for \link{VN.dep}.  Categorical variables typically require \code{dep.order=1}.  Error message will alert user if this is the case.}
}
\value{
Returns two variables, mean squared error "\code{MSE}" and fitted values "\code{Fitted}" as well as the number of predictors, R2, R2 Adjusted, and Prediction Accuracy measured by percentage of exact classifications.
}
\description{
Classifies data based on multiple logistic nonlinear regression \code{VN.reg}
}
\examples{
## Using 'iris' dataset where predictive attributes are columns 1:4, and the class is column 5.
VN.class(iris,5)

## To call mean squared error
VN.class(iris,5)$MSE

## To call fitted values
VN.class(iris,5)$Fitted
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{classifier}
\keyword{logistic}
\keyword{nonlinear}
\keyword{regression,}

