% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-apps.R
\name{shiny_nm}
\alias{shiny_nm}
\title{Run monitor & summary app}
\usage{
shiny_nm(m, envir = .GlobalEnv)
}
\arguments{
\item{m}{Either an nm object, or data.frame or list or environment contain
nm_lists.}

\item{envir}{If missing, the environment to search.}
}
\value{
No return value, called for side effects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Interactively monitor NONMEM runs.  This interface is intentionally limited
to monitoring runs, and does not include the ability to create, modify,
launch or post-process runs since actions performed in the shiny app are not
traceable/reproducible and not part of the workflow you create when
scripting.
}
\examples{

if(interactive()){

#' # create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

shiny_nm() ## use all objects in global workspace
shiny_nm(m1) ## only m1

## if model objects are inside a tibble
d <- dplyr::tibble(m = m1)

shiny_nm(d$m) ## only d$m
shiny_nm(d) ## all nm_lists in d (data.frame/list/environment)

}
  

}
