% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_OCC_every_dose.R
\name{make_OCC_every_dose}
\alias{make_OCC_every_dose}
\title{Make an OCC column for NONMEM IOV use}
\usage{
make_OCC_every_dose(d, dose_trigger, new_OCC_trigger)
}
\arguments{
\item{d}{A data.frame. NONMEM ready input dataset.}

\item{dose_trigger}{Logical expression for defining a dosing row.}

\item{new_OCC_trigger}{Logical expression for defining when OCC should
increment.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates and OCC column that increments in accordance to specified condition.
To be used in a \code{dplyr::mutate()} statement \code{dplyr::group_by()}'d by "ID".
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

d <- input_data(m1)

## OCC increments on every dosing interval with more than 4 samples
d \%>\% make_OCC_every_dose(!is.na(AMT), any(!is.na(DV)))

}
