% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitoring.R
\name{wait_finish}
\alias{wait_finish}
\title{Wait for runs to finish}
\usage{
wait_finish(r, timeout = NA)
}
\arguments{
\item{r}{An nm object.}

\item{timeout}{Numeric seconds to wait before timeout.}
}
\value{
Invisibly returns \code{r} unmodified.  Called for side effects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Blocks subsequent r execution until run(s) are finished.  This is useful for
when subsequent relies on outputs from completed NONMEM jobs.  It is normally
a good idea to include this in post processing R markdown templates, to
ensure they wait for runs to complete before executing.
}
\examples{

## requires NONMEM to be installed

\dontrun{
# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 \%>\%
  run_nm() \%>\%
  wait_finish()

## following requires run to be completed.
covariance_plot(m1)
}

}
