% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level-ctl-handling-funs.R
\name{gsub_ctl}
\alias{gsub_ctl}
\title{Pattern replacement for control file contents}
\usage{
gsub_ctl(m, pattern, replacement, ..., dollar = NA_character_)
}
\arguments{
\item{m}{An nm object.}

\item{pattern}{Argument passed to \code{\link[=gsub]{gsub()}}.}

\item{replacement}{Argument passed to \code{\link[=gsub]{gsub()}}.}

\item{...}{Additional arguments passed to \code{\link[=gsub]{gsub()}}.}

\item{dollar}{Character name of subroutine.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A wrapper around \code{gsub} so that control files may be modified using \code{gsub}
syntax.  Can be useful for simple find replace operations in a control
stream.  Ensure you use the "view diff" app afterwards to make sure the find
replace proceeded as intended.
}
\examples{


# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))


m1 \%>\% dollar("EST")

m1 <- m1 \%>\% gsub_ctl("ISAMPLE=300", "ISAMPLE=600")

m1 \%>\% dollar("EST")

}
\seealso{
\code{\link[=apply_manual_edit]{apply_manual_edit()}}
}
