% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param-manipulate.R
\name{add_mixed_param}
\alias{add_mixed_param}
\title{Add a mixed effect parameter to $PK (or $PRED)}
\usage{
add_mixed_param(
  m,
  name,
  init = 1,
  unit = "",
  trans = c("LOG"),
  position = NA_integer_,
  after = character()
)
}
\arguments{
\item{m}{An nm object.}

\item{name}{Character. Name of NONMEM variable to create.}

\item{init}{Numeric (default = \code{1}). Initial value of fixed effect.}

\item{unit}{Character (default = \code{""}). Unit of variable.}

\item{trans}{Character (default = \code{"LOG"}). Transformation of the variable.}

\item{position}{Integer. Not used.}

\item{after}{Character. Pattern to match and include the mixed effect after.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Primarily an internal function. This will (by default) add a parameter (mixed
effect) to your code $PK/$PRED and $THETA/$OMEGA.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 \%>\% dollar("PK")
m1 \%>\% dollar("THETA")

m1 <- m1 \%>\% add_mixed_param("ALAG1", init = 1.1, unit = "h", trans = "LOG")

m1 \%>\% dollar("PK")
m1 \%>\% dollar("THETA")

}
