% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitoring.R
\name{status_table}
\alias{status_table}
\title{Get status of multiple runs in form of table}
\usage{
status_table(m)
}
\arguments{
\item{m}{An nm object.}
}
\value{
A \code{tibble} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A more friendly version of \code{\link[=status]{status()}} for vector valued nm objects.  Useful
after bootstraps, or stepwise covariate method steps, or any situation
dealing with groups of NONMEM runs.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))
             
c(m1, m1) \%>\% status_table()  ## both not started
}
