% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm-gettersetters.R
\name{nm_getsetters_execution}
\alias{nm_getsetters_execution}
\alias{cores}
\alias{parafile}
\alias{walltime}
\alias{executed}
\title{Execution related functions to access and modify fields of nm objects}
\usage{
cores(m, text)

parafile(m, text)

walltime(m, text)

executed(m, text)
}
\arguments{
\item{m}{An nm object.}

\item{text}{Optional character for replacing field. If present function will
modify field (of same name as function) otherwise will return value of
field (of same name as function).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The fields of an object can be viewed by printing the object.  Each field has
a corresponding function of the same name to access and modify it's value.
}
\details{
Easiest way to see all fields of an object is to type the object
into the console and hit enter. This will display the value of each field.
some fields like \code{cmd} are glue fields.  In these cases inserting
expressions inside braces in \code{text} will evaluate the expression

The fundamental structure of all these functions is the same:

To access the value of a field:
\code{m \%>\% fieldname()} or equivalently \code{fieldname(m)}

To modify the value of a field:
\code{m <- m \%>\% fieldname("newvalue")}
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 <- m1 \%>\% cmd("execute -parafile={parafile} {ctl_name} -dir={run_dir} -nodes={cores}")

m1 <- m1 \%>\% cores(8) \%>\% parafile("mpilinux8.pnm")

cmd(m1)
cores(m1)


}
