% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job_stats.R
\name{job_stats}
\alias{job_stats}
\title{Get job stats for a completed NONMEM run}
\usage{
job_stats(m)
}
\arguments{
\item{m}{An nm object.}
}
\value{
A wide format \code{tibble} with information about the job execution
times.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Gets attributes of the run like run time, queue time.
}
\examples{

## Below code requires NONMEM to be installed
\dontrun{

#' # create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

dc <- tibble(cores = c(1, 3, 10, 30)) \%>\%
  mutate(m = m1 \%>\%
    child(run_id = cores) \%>\%
    run_in("Models/m1_coretest") \%>\%
    cmd("execute {ctl_name} -parafile={parafile} -dir={run_dir} -nodes={cores}") \%>\%
    parafile("/opt/NONMEM/nm75/run/mpilinux8.pnm") \%>\%
    cores(cores))

dc$m \%>\% cmd()

dc$m \%>\%
  run_nm() \%>\%
  wait_finish()

## extract job statistics and plot cores vs Rtime or Ttime
## to get plots of run time and total time vs number of CPUs

dc$m \%>\%
  job_stats() \%>\%
  ggplot(aes(x = cores, y = Rtime)) +
  theme_bw() +
  geom_point()
}

}
