% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadCsv.R
\name{NMreadCsv}
\alias{NMreadCsv}
\title{Read input data formatted for Nonmem}
\usage{
NMreadCsv(
  file,
  args.fread,
  as.fun = NULL,
  format = fnExtension(file),
  args.fst
)
}
\arguments{
\item{file}{The file to read. Must be pure text.}

\item{args.fread}{List of arguments passed to fread. Notice that
except for "file", you need to supply all arguments to fread
if you use this argument. Default values can be configured
using NMdataConf.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{format}{Format of file to read. Can be of length>1 in which
case the first format found will be used (i.e. format is a
prioritized vector). If not one of "rds" or "fst", it is
assumed to be a delimited text file. Default is to determine
this from the file name extension. Notice, if a delimited
format is used, the extension can very well be different from
"csv" (say file name is
"input.tab")". This will work for any delimited format supported by fread.}

\item{args.fst}{Optional arguments to pass to \code{read_fst} if \code{format="fst"} is used.}
}
\value{
A data set of class as defined by as.fun.
}
\description{
This function is especially useful if the csv file was written
using NMwriteData.
}
\details{
This is almost just a shortcut to fread so you don't have to remember how to read the data that was exported for Nonmem. The only added feature is that meta data as written by NMwriteData is read and attached as NMdata metadata before data is returned.
}
\seealso{
NMwriteData

Other DataRead: 
\code{\link{NMreadTab}()},
\code{\link{NMscanData}()},
\code{\link{NMscanInput}()},
\code{\link{NMscanTables}()}
}
\concept{DataRead}
