% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMwriteSection.R
\name{NMwriteSection}
\alias{NMwriteSection}
\title{replace ($)sections of a nonmem control stream}
\usage{
NMwriteSection(
  file,
  section,
  newlines,
  list.sections,
  newfile,
  backup = TRUE,
  blank.append = TRUE,
  write = TRUE
)
}
\arguments{
\item{file}{File path to the model (control stream) to edit.}

\item{section}{The name of the section to update. Example:
section="EST" to edit the sections starting by $EST. See
NMreadSection}

\item{newlines}{The new text (including "$SECTION"). Better be
broken into lines in a character vector since this is simply
past to writeLines.}

\item{list.sections}{Named list of new sections, each element
containing a section. Names must be section names, contents of
each element are the new section lines for each section.}

\item{newfile}{path to new run. If missing, path is used. If NULL,
output is returned rather than written.}

\item{backup}{In case you are overwriting the old file, do you
want to backup the file (to say, backup_run001.mod)?}

\item{blank.append}{Append a blank line to output?}

\item{write}{Default is to write to file. If write=FALSE,
NMwriteSection returns the resulting input.txt without writing
it.  to disk?  Default is FALSE.}
}
\value{
The new section text is returned. If write=TRUE, this is done invisibly.
}
\description{
Just give the section name, the new lines and the file path, and the
"$section", and the input to Nonmem will be updated.
}
\details{
The new file will be written with unix-style line
    endings.
}
\examples{
newlines <- "$EST POSTHOC INTERACTION METHOD=1 NOABORT PRINT=5 MAXEVAL=9999 SIG=3"
NMwriteSection(file=system.file("examples/nonmem/xgxr001.mod", package = "NMdata"),
section="EST", newlines=newlines,newfile=NULL)
}
\seealso{
Other Nonmem: 
\code{\link{NMapplyFilters}()},
\code{\link{NMextractText}()},
\code{\link{NMreadSection}()},
\code{\link{NMwriteData}()}
}
\concept{Nonmem}
