% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMwriteData.R
\name{NMwriteData}
\alias{NMwriteData}
\title{Write dataset for use in Nonmem (and R)}
\usage{
NMwriteData(
  data,
  file,
  write.csv = TRUE,
  write.rds = write.csv,
  write.RData = FALSE,
  script,
  args.stamp,
  args.fwrite,
  args.rds,
  args.RData,
  nm.drop,
  nmdir.data,
  col.flag = "FLAG",
  nm.rename,
  nm.copy,
  nm.capitalize = FALSE,
  allow.char.TIME = TRUE,
  quiet
)
}
\arguments{
\item{data}{The dataset to write to file for use in Nonmem.}

\item{file}{The file to write to. The extension (everything after
and including last ".") is dropped. csv, rds and other
standard file name extensions are added.}

\item{write.csv}{Write to csv file?}

\item{write.rds}{write an rds file?}

\item{write.RData}{In case you want to save to .RData object. Not
recommended. Use write.rds instead.}

\item{script}{If provided, the object will be stamped with this
script name before saved to rds or Rdata. See ?NMstamp.}

\item{args.stamp}{A list of arguments to be passed to NMstamp.}

\item{args.fwrite}{List of arguments passed to fwrite. Notice that
except for "x" and "file", you need to supply all arguments to
fwrite if you use this argument. Default values can be
configured using NMdataConf.}

\item{args.rds}{A list of arguments to be passed to saveRDS.}

\item{args.RData}{A list of arguments to be passed to save.}

\item{nm.drop}{Only used for generation of proposed text for
Nonmem control stream. Columns to drop in Nonmem $DATA. This
has two implications. One is that the proposed $DATA indicates
=DROP after the given column names. The other that in case it
is a non-numeric column, succeeding columns can still be
included.}

\item{nmdir.data}{For the $DATA text proposal only. The path to
the input datafile to be used in the Nonmem $DATA
section. Often, a relative path to the actual Nonmem run is
wanted here.}

\item{col.flag}{Name of a numeric column with zero value for rows
to include in Nonmem run, non-zero for rows to skip. The
argument is only used for generating the proposed text to
paste into the Nonmem control stream. To skip this feature,
use col.flag=NULL.}

\item{nm.rename}{For the $DATA text proposal only. If you plan to
rename columns in Nonmem $DATA, NMwriteData can adjust the
suggested $DATA text. If you plan to use BBW instead of BWBASE
in Nonmem, consider nm.rename=c(BWBASE="BBW"). The result is
different from nm.copy since the nm.copy syntax is only
allowed by Nonmem for certain standard column names such as
DV.}

\item{nm.copy}{For the $DATA text proposal only. If you plan to
rename columns in Nonmem $DATA, NMwriteData can adjust the
suggested $DATA text. If you plan to use CONC as DV in Nonmem,
you can include nm.rename=c(DV="CONC").}

\item{nm.capitalize}{For the $DATA text proposal only. If TRUE,
the suggested text for Nonmem will only contain capital
letters in column names.}

\item{allow.char.TIME}{For the $DATA text proposal only. Assume
Nonmem can read TIME even if it can't be translated to
numeric. This is necessary if using the 00:00 format. Default
is TRUE.}

\item{quiet}{The default is to give some information along the way
on what data is found. But consider setting this to TRUE for
non-interactive use. Default can be configured using
NMdataConf.}
}
\value{
Text for inclusion in Nonmem control stream, invisibly.
}
\description{
Instead of trying to remember the arguments to pass to write.csv,
use this wrapper. It tells you what to write in $DATA and $INPUT
in nonmem, and it (additionally) exports an rds or Rdata file as
well which is highly preferable for use in R. It never edits the
data before writing the datafile. The filenames for csv, rds
etc. are derived by replacing the extension to the filename given
in the file argument.
}
\details{
When writing csv files, the file will be
    comma-separated. Because Nonmem does not support quoted
    fields, you must avoid commas in character fields. An error is
    returned if commas are found in strings.

The user is provided with text to use in Nonmem. This lists names
of the data columns. Once a column is reached that Nonmem will not
be able to read as a numeric and column is not in nm.drop, the list
is stopped. Only exception is TIME which is not tested for whether
character or not.
}
\seealso{
Other Nonmem: 
\code{\link{NMapplyFilters}()},
\code{\link{NMextractText}()},
\code{\link{NMreadSection}()},
\code{\link{NMwriteSection}()}
}
\concept{Nonmem}
