% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMscanMultiple.R
\name{NMscanMultiple}
\alias{NMscanMultiple}
\title{Run NMscanData on multiple models and stack results}
\usage{
NMscanMultiple(files, dir, file.pattern, as.fun, ...)
}
\arguments{
\item{files}{File paths to the models (control stream) to
edit. See file.pattern too.}

\item{dir}{The directory in which to find the models. Passed to
list.files(). See file.pattern argument too.}

\item{file.pattern}{The pattern used to match the filenames to read
with NMscanData. Passed to list.files(). See dir argument too.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{...}{Additional arguments passed to NMscanData.}
}
\value{
All results stacked, class as defined by as.fun
}
\description{
Useful function for meta analyses when multiple models are stored
in one folder and can be read with NMscanData using the same
arguments.
}
\examples{
res <- NMscanMultiple(dir=system.file("examples/nonmem", package="NMdata"),
file.pattern="xgxr01.*\\\\.lst",as.fun="data.table")
res.mean <- res[,.(meanPRED=exp(mean(log(PRED)))),by=.(model,NOMTIME)]
library(ggplot2)
ggplot(res.mean,aes(NOMTIME,meanPRED,colour=model))+geom_line() 
}
