% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMgenText.R
\name{NMgenText}
\alias{NMgenText}
\title{Generate text for INPUT and possibly DATA sections of NONMEM
control streams.}
\usage{
NMgenText(
  data,
  drop,
  col.flagn = "FLAG",
  rename,
  copy,
  file,
  dir.data,
  capitalize = FALSE,
  until,
  allow.char.TIME = TRUE,
  width,
  quiet
)
}
\arguments{
\item{data}{The data that NONMEM will read.}

\item{drop}{Only used for generation of proposed text for INPUT
section. Columns to drop in Nonmem $INPUT. This has two
implications. One is that the proposed $INPUT indicates =DROP
after the given column names. The other that in case it is a
non-numeric column, succeeding columns will still be included
in $INPUT and can be read by NONMEM.}

\item{col.flagn}{Name of a numeric column with zero value for rows
to include in Nonmem run, non-zero for rows to skip. The
argument is only used for generating the proposed $DATA text
to paste into the Nonmem control stream. To skip this feature,
use col.flagn=NULL. Default is defined by NMdataConf.}

\item{rename}{For the $INPUT text proposal only. If you want to
rename columns in NONMEM $DATA, NMwriteData can adjust the
suggested $DATA text. If you plan to use BBW instead of BWBASE
in Nonmem, consider rename=c(BBW="BWBASE"). The result will
include BBW and not BWBASE.}

\item{copy}{For the $INPUT text proposal only. If you plan to use
additional names for columns in Nonmem $INPUT, NMwriteData can
adjust the suggested $INPUT text. Say you plan to use CONC as
DV in Nonmem, use copy=c(DV="CONC"),
i.e. copy=c(newname="existing"). INPUT suggestion will in this
case contain DV=CONC.}

\item{file}{The file name NONMEM will read the data from (for the
$DATA section). It can be a full path.}

\item{dir.data}{For the $DATA text proposal only. The path to the
input datafile to be used in the Nonmem $DATA section. Often,
a relative path to the actual Nonmem run is wanted here. If
this is used, only the file name and not the path from the
file argument is used.}

\item{capitalize}{For the $INPUT text proposal only. If TRUE, all
column names in $INPUT text will be converted to capital
letters.}

\item{until}{Use this to truncate the columns in $INPUT. until can
either be a character (column name) or a numeric (column
number). If a character is given, it is matched against the
resulting column name representation in $INPUT, i.e. this
could be "DV=CONC" if you are using in this case the copy
argument. In case until is of length>1, the maximum will be
used (probably only interesting if character values are
supplied).}

\item{allow.char.TIME}{For the $INPUT text proposal only. Assume
Nonmem can read TIME even if it can't be translated to
numeric. This is necessary if using the 00:00 format. Default
is TRUE.}

\item{width}{If positive, will be passed to strwrap for the $INPUT
text. If missing or NULL, strwrap will be called with default
value. If negative or zero, strwrap will not be called.}

\item{quiet}{Hold messages back? Default is defined by NMdataConf.}
}
\value{
Text for inclusion in Nonmem control stream, invisibly.
}
\description{
The user is provided with text to use in Nonmem. NMwriteSection
can use the results to update the control streams. INPUT lists
names of the data columns while DATA provides a path to data and
ACCEPT/IGNORE statements. Once a column is reached that Nonmem
will not be able to read as a numeric and column is not in
nm.drop, the list is stopped. Only exception is TIME which is not
tested for whether character or not.
}
\seealso{
Other Nonmem: 
\code{\link{NMapplyFilters}()},
\code{\link{NMextractText}()},
\code{\link{NMreadSection}()},
\code{\link{NMwriteSection}()}
}
\concept{Nonmem}
