% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_fbm.R
\name{nlm_fbm}
\alias{nlm_fbm}
\title{nlm_fbm}
\usage{
nlm_fbm(ncol, nrow, resolution = 1, fract_dim = 1, user_seed = NULL,
  rescale = TRUE, ...)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{fract_dim}{[\code{numerical(1)}]\cr
The fractal dimension of the process (0,2)}

\item{user_seed}{[\code{numerical(1)}]\cr
Set random seed for the simulation}

\item{rescale}{[\code{numeric(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}

\item{...}{Other options to RandomFields::RFoptions, especially if using
a fractal dimension between ~ 1.6 and 1.9 one must set the option
\code{modus_operandi = "sloppy"}.}
}
\value{
RasterLayer
}
\description{
Creates a two-dimensional fractional Brownian motion neutral landscape model.
}
\details{
Neutral landscapes are generated using fractional Brownian motion,
 an extension of Brownian motion in which the amount of correlation between
  steps is controlled by \code{frac_dim}. A high value of \code{frac_dim} produces a
   relatively smooth, correlated surface while a low value produces a rough, uncorrelated one.
}
\examples{
# simulate fractional brownian motion
fbm_raster  <- nlm_fbm(ncol = 20, nrow = 30, fract_dim = 0.8)

\dontrun{

# visualize the NLM
landscapetools::util_plot(fbm_raster)

}

}
\references{
Travis, J.M.J. & Dytham, C. (2004). A method for simulating patterns of
habitat availability at static and dynamic range margins. \emph{Oikos} , 104, 410–416.

Martin Schlather, Alexander Malinowski, Peter J. Menck, Marco Oesting,
Kirstin Strokorb (2015). nlm_fBm. \emph{Journal of Statistical
Software}, 63(8), 1-25. URL http://www.jstatsoft.org/v63/i08/.
}
