% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNewCovariate}
\alias{chmNewCovariate}
\title{Create a new Covariate for adding to an NGCHM auxilary dataset.}
\usage{
chmNewCovariate(
  fullname,
  values,
  value.properties = NULL,
  type = NULL,
  covabbv = NULL
)
}
\arguments{
\item{fullname}{The full (human readable) name of the covariate.}

\item{values}{A named vector of values (character, logical, or numeric).}

\item{value.properties}{An ngchmColormap mapping values to properties.}

\item{type}{The string "discrete" or the string "continuous".  (Defaults to continuous for numeric values, to discrete otherwise.)}

\item{covabbv}{The short R-compatible identifier used to identify the covariate (derived from fullname if not specified).}
}
\value{
An object of class ngchmCovariate.
}
\description{
This function creates a new Covariate suitable for a covariate bar or attaching to an NGCHM auxilary dataset.
}
\seealso{
\linkS4class{ngchmCovariate}

\code{\link[=chmAddCovariate]{chmAddCovariate()}}

\code{\link[=chmNewColorMap]{chmNewColorMap()}}
}
