% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmColors}
\alias{chmColors}
\title{Get the colors of an ngchmColormap, ngchmLayer, ngchmBar, or ngchmCovariate.}
\usage{
chmColors(x)
}
\arguments{
\item{x}{The object to get the colors of.}
}
\value{
A character string vector of the map colors.
}
\description{
Get the colors of an ngchmColormap, ngchmLayer, ngchmBar, or ngchmCovariate.
}
\examples{
# If the NGCHMDemoData package is installed, use it to demo usage
if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
  data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
  colors <- chmColors(chmNewDataLayer("GBM Expression", TCGA.GBM.EXPR[1:50, 1:50]))
}
# Small example not requiring NGCHMDemoData
matrix <- matrix(rnorm(100),
  nrow = 10, ncol = 10,
  dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
)
colors <- chmColors(chmNewDataLayer("my layer", matrix))

}
\seealso{
\linkS4class{ngchm}
}
