/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class SpearmanCorrelationSimilarity
implements UserSimilarity {
    private final DataModel dataModel;

    public SpearmanCorrelationSimilarity(DataModel dataModel) {
        this.dataModel = Preconditions.checkNotNull(dataModel);
    }

    @Override
    public double userSimilarity(long userID1, long userID2) throws TasteException {
        int i;
        PreferenceArray xPrefs = this.dataModel.getPreferencesFromUser(userID1);
        PreferenceArray yPrefs = this.dataModel.getPreferencesFromUser(userID2);
        int xLength = xPrefs.length();
        int yLength = yPrefs.length();
        if (xLength <= 1 || yLength <= 1) {
            return Double.NaN;
        }
        xPrefs = xPrefs.clone();
        yPrefs = yPrefs.clone();
        xPrefs.sortByValue();
        yPrefs.sortByValue();
        float nextRank = 1.0f;
        for (i = 0; i < xLength; ++i) {
            if (!yPrefs.hasPrefWithItemID(xPrefs.getItemID(i))) continue;
            xPrefs.setValue(i, nextRank);
            nextRank += 1.0f;
        }
        nextRank = 1.0f;
        for (i = 0; i < yLength; ++i) {
            if (!xPrefs.hasPrefWithItemID(yPrefs.getItemID(i))) continue;
            yPrefs.setValue(i, nextRank);
            nextRank += 1.0f;
        }
        xPrefs.sortByItem();
        yPrefs.sortByItem();
        long xIndex = xPrefs.getItemID(0);
        long yIndex = yPrefs.getItemID(0);
        int xPrefIndex = 0;
        int yPrefIndex = 0;
        double sumXYRankDiff2 = 0.0;
        int count = 0;
        while (true) {
            int compare;
            int n = xIndex < yIndex ? -1 : (compare = xIndex > yIndex ? 1 : 0);
            if (compare == 0) {
                double diff = xPrefs.getValue(xPrefIndex) - yPrefs.getValue(yPrefIndex);
                sumXYRankDiff2 += diff * diff;
                ++count;
            }
            if (compare <= 0) {
                if (++xPrefIndex >= xLength) break;
                xIndex = xPrefs.getItemID(xPrefIndex);
            }
            if (compare < 0) continue;
            if (++yPrefIndex >= yLength) break;
            yIndex = yPrefs.getItemID(yPrefIndex);
        }
        if (count <= 1) {
            return Double.NaN;
        }
        return 1.0 - 6.0 * sumXYRankDiff2 / (double)(count * (count * count - 1));
    }

    @Override
    public void setPreferenceInferrer(PreferenceInferrer inferrer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.dataModel);
    }
}

