% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Buildx_xvec.R
\name{GetAuxPara}
\alias{GetAuxPara}
\title{Map constrained parameters b to unconstrained auxiliary parameters a.}
\usage{
GetAuxPara(
  ParaValue,
  Const_Type_Full,
  lb,
  ub,
  Economies,
  FactorLabels,
  JLLinputs = NULL
)
}
\arguments{
\item{ParaValue}{Constrained parameter}

\item{Const_Type_Full}{character-based vector that describes the constraints. Constraints are:
\itemize{
\item 'Jordan';
\item 'Jordan; stationary'
\item 'Jordan MultiCountry'
\item 'Jordan MultiCountry; stationary'
\item 'stationary'
\item 'psd'
\item 'BlockDiag'
\item 'bounded'
\item 'diag'
\item 'JLLstructure'
  }}

\item{lb}{lower bounds (a scalar or a matrix) of ParaValue (for the bounded case).}

\item{ub}{upper bounds (a scalar or a matrix) of ParaValue (for the bounded case).}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{JLLinputs}{list of necessary inputs for the estimation of JLL-based models (see "JLL" function)}
}
\value{
unconstrained auxiliary matrix.
}
\description{
Map constrained parameters b to unconstrained auxiliary parameters a.
}
\references{
This function is a modified and extended version of the "true2aux" function by Le and Singleton (2018). \cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
\keyword{internal}
