% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ring_read.R
\name{ring_read}
\alias{ring_read}
\title{Read and plot a tree-ring image file}
\usage{
ring_read(img, dpi = NULL, RGB = c(0.299, 0.587, 0.114),
  plot = FALSE, rotate = 0, magick = TRUE)
}
\arguments{
\item{img}{A character string indicating the path of the image file. 
Supported formats include png, tiff, jpg and bmp.}

\item{dpi}{An integer specifying the dpi of the image file. A minimum of 
300 dpi is required when running automatic detection.}

\item{RGB}{A numeric vector of length 3 giving the weight of RGB channels.}

\item{plot}{A logical value indicating whether to plot the tree ring image 
when reading it. If \code{FALSE}, the image is not plotted until
function \code{\link{ring_detect}} or \code{\link{pith_measure}} is called.}

\item{rotate}{An integer specifying how many degrees to rotate (clockwise). 
It requires one of the following values:
\code{0}, \code{90}, \code{180} or \code{270}.}

\item{magick}{A logical value. If \code{TRUE}, \code{magick} is used to
read the image file whose size is over 10MB. If \code{FALSE},
packages \code{png}, \code{jpg} and \code{tiff} are used instead.
See details below.}
}
\value{
A magick image object containing the image data.
}
\description{
This function can read an image file from the hard disk and 
plot it in a newly-opened graphics device.
}
\details{
Proper image preparation has a great influence on the measurement of 
ring widths. A tree-ring image should not contain irrelevant or redundant 
features, such as wooden mounts where cores are glued. The larger the file 
size of an image, the slower the image processing operation will be.

\bold{Pith side} of a wood sample should be placed on the \bold{right side} 
of a graphics window. Use \code{rotate} to change its position.

It is highly recommended to use the default value \code{magick = TRUE}, 
because the package \code{magick} can significantly reduce the memory usage
when reading a large file.
In a few cases where image data is stored in a non-standard format, 
\code{magick} may return an error when reading files. 
If \code{ring_read} fails reading a large file,
you can set \code{magick = FALSE} to avoid the use of \code{magick}.
}
\examples{
img.path <- system.file("001.png", package = "MtreeRing")

## Read and plot the image:
t1 <- ring_read(img = img.path, dpi = 1200, plot = TRUE)
}
\author{
Jingning Shi
}
