% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msde.fit.R
\name{msde.fit}
\alias{msde.fit}
\title{Estimation Of The Random Effects In Mixed Stochastic Differential Equations}
\usage{
msde.fit(times, X, model = c("OU", "CIR"), drift.random = c(1, 2),
  drift.fixed = NULL, diffusion.random = 0, diffusion.fixed = NULL,
  nb.mixt = 1, Niter = 10, discrete = 1, valid = 0, level = 0.05,
  newwindow = FALSE)
}
\arguments{
\item{times}{vector of observation times}

\item{X}{matrix of the M trajectories (each row is a trajectory with as much columns as observations)}

\item{model}{name of the SDE: 'OU' (Ornstein-Uhlenbeck) or 'CIR' (Cox-Ingersoll-Ross)}

\item{drift.random}{random effects in the drift: 0 if only fixed effects, 1 if one additive random effect, 2 if one multiplicative random effect or c(1,2) if 2 random effects. Default to c(1,2)}

\item{drift.fixed}{NULL if the fixed effect(s) in the drift is (are) estimated, value of the fixed effect(s) otherwise. Default to NULL}

\item{diffusion.random}{1 if \eqn{\sigma} is random, 0 otherwise. Default to 0}

\item{diffusion.fixed}{NULL if \eqn{\sigma} is estimated (if fixed), value of \eqn{\sigma} otherwise. Default to NULL}

\item{nb.mixt}{number of mixture components for the distribution of the random effects in the drift. Default to 1 (no mixture)}

\item{Niter}{number of iterations for the EM algorithm if the random effects in the drift follow a mixture distribution. Default to 10}

\item{discrete}{1 for using a contrast based on discrete observations, 0 otherwise. Default to 1}

\item{valid}{1 if test validation, 0 otherwise. Default to 0}

\item{level}{alpha for the predicion intervals. Default 0.05}

\item{newwindow}{logical(1), if TRUE, a new window is opened for the plot. Default to FALSE}
}
\value{
\item{index}{is the vector of subscript in 1,...,M used for the estimation. Most of the time index=1:M, except for the CIR that requires positive trajectories.}
\item{estimphi}{matrix of estimators of the drift random effects \eqn{\hat{\alpha}_j}, or \eqn{\hat{\beta}_j} or \eqn{(\hat{\alpha}_j,\hat{\beta}_j)}}
\item{estimpsi2}{vector of estimators of the squared diffusion random effects \eqn{\hat{\sigma}_j^2}}
\item{gridf}{grid of values for the plots of the random effects distribution in the drift, matrix form}
\item{gridg}{grid of values for the plots of the random effects distribution in the diffusion, matrix form}
\item{estimf}{estimator of the density of \eqn{\alpha_j}, \eqn{\beta_j} or \eqn{(\alpha_j,\beta_j)}. Matrix form.}
\item{estimg}{estimator of the density of \eqn{\sigma_j^2}. Matrix form.}
\item{mu}{estimator of the mean of the random effects normal density}
\item{omega}{estimator of the standard deviation of the random effects normal density}
\item{a}{estimated value of the shape of the Gamma distribution}
\item{lambda}{estimated value of the scale of the Gamma distribution}
\item{sigma2}{value of the diffusion coefficient if it is fixed}
\item{bic}{BIC criterium}
\item{aic}{AIC criterium}
\item{model}{initial choice}
\item{drift.random}{initial choice}
\item{diffusion.random}{initial choice}
\item{drift.fixed}{initial choice}
\item{estim.drift.fix}{1 if the fixed effects in the drift are estimated, 0 otherwise.}
\item{estim.diffusion.fixed}{1 if the fixed effect in the diffusion is estimated, 0 otherwise.}
\item{discrete}{initial choice}
\item{times}{initial choice}
\item{X}{initial choice}

For mixture distributions in the drift:
\item{mu}{estimated value of the mean at each iteration of the algorithm. Niter x N x 2 array. }
\item{omega}{estimated value of the standard deviation at each iteration of the algorithm. Niter x N x 2 array.}
\item{mixt.prop}{estimated value of the mixture proportions at each iteration of the algorithm. Niter x N matrix.}
\item{probindi}{posterior component probabilites. M x N matrix.}
}
\description{
Parametric estimation of the joint density of the random effects in the mixed SDE

 \deqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma_j \ a(X_j(t)) dW_j(t),}
 \eqn{j=1,\ldots,M}, where the \eqn{(W_j(t))} are independant Wiener processes and the \eqn{(X_j(t))} are observed without noise. 
 There can be random effects either in the drift \eqn{(\alpha_j,\beta_j)} or in the diffusion coefficient \eqn{\sigma_j} or both
 \eqn{(\alpha_j,\beta_j,\sigma_j)}.
}
\details{
Parametric estimation of the random effects density from M independent trajectories of the SDE:
\deqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma_j \ a(X_j(t)) dW_j(t),}
\eqn{j=1,\ldots,M}, where the \eqn{(W_j(t))} are independant Wiener processes and the \eqn{(X_j(t))} are observed without noise. 

\bold{Specification of the random effects:}

The drift includes no, one or two random effects: 
\enumerate{
\item if drift.random = 0: \eqn{\alpha_j \equiv \alpha} and \eqn{\beta_j \equiv \beta} are fixed
\item if drift.random = 1: \eqn{\beta_j \equiv \beta} is fixed and \eqn{\alpha_j} is random
\item if drift.random = 2: \eqn{\alpha_j \equiv \alpha} is fixed and \eqn{\beta_j} is random  
\item if drift.random = c(1,2): \eqn{\alpha_j} and \eqn{\beta_j} are random
}

The diffusion includes either a fixed effect or a random effect:
\enumerate{
\item if diffusion.random = 0: \eqn{\sigma_j \equiv \sigma} is fixed
\item if diffusion.random = 1: \eqn{\sigma_j} is random
}

\bold{Distribution of the random effects}

If there is no random effect in the diffusion (diffusion.random = 0), there is at least on random effect in the drift that follows
\enumerate{
\item a Gaussian distribution (nb.mixt=1): 
\eqn{\alpha_j \sim N(\mu,\Omega)} or \eqn{\beta_j \sim N(\mu,\Omega)} or \eqn{(\alpha_j,\beta_j) \sim N(\mu,\Omega)},
\item or a mixture of Gaussian distributions (nb.mixt=K, K>1):
\eqn{\alpha_j \sim \sum_{k=1}^{K} p_k N(\mu_k,\Omega_k)} or \eqn{\beta_j \sim \sum_{k=1}^{K} p_k N(\mu_k,\Omega_k)} or \eqn{(\alpha_j,\beta_j) \sim \sum_{k=1}^{K} p_k N(\mu_k,\Omega_k)},
where \eqn{\sum_{k=1}^{K} p_k=1.}
} 

If there is one random effect in the diffusion (diffusion.random = 1), \eqn{1/\sigma_j^2 \sim \Gamma(a,\lambda)}, and the coefficients
in the drift are conditionally Gaussian: \eqn{\alpha_j|\sigma_j \sim N(\mu,\sigma_j^2 \Omega)} or \eqn{\beta_j|\sigma_j \sim N(\mu,\sigma_j^2 \Omega)} 
or \eqn{(\alpha_j,\beta_j)|\sigma_j \sim N(\mu,\sigma_j^2 \Omega)}, or they are fixed \eqn{\alpha_j \equiv \alpha, \beta_j \equiv \beta}.

\bold{SDEs}

Two diffusions are implemented: 
\enumerate{
\item the Ornstein-Uhlenbeck model (OU) \eqn{a(X_j(t))=1}
\item the Cox-Ingersoll-Ross model (CIR) \eqn{a(X_j(t))=\sqrt{X_j(t)}}
}


\bold{Estimation}

\itemize{
\item If discrete = 0, the estimation is based on the exact likelihood associated with continuous observations ([1],[3]). This is only possible if diffusion.random = 0 and
\eqn{\sigma} is not estimated by maximum likelihood but empirically by means of the quadratic variations. 
\item If discrete = 1, the likelihood of the Euler scheme of the mixed SDE is computed and maximized for estimating all the parameters.
\item If nb.mixt > 1, an EM algorithm is implemented and the number of iterations of the algorithm must be specified with Niter.
\item If valid = 1, two-thirds of the sample trajectories are used for estimation, while the rest is used for validation. A plot is then provided for
visual comparison between the true trajectories of the test sample and some predicted trajectories simulated under the estimated model.
}
}
\examples{


# Example 1 : One random effect in the drift and one random effect in the diffusion

sim <- msde.sim(M = 25, T = 1, N = 1000, model = 'OU', 
                drift.random = 2, drift.param = c(0,0.5,0.5), 
                diffusion.random = 1, diffusion.param = c(8,1/2))

res <- msde.fit(times = sim$times, X = sim$X, model = 'OU', drift.random = 2, 
diffusion.random = 1)

summary(res)
plot(res)

\dontrun{

# Example 2 : one mixture of two random effects in the drift, and one fixed effect in
# the diffusion coefficient

sim <- msde.sim(M = 100, T = 5, N = 5000, model = 'OU', drift.random = c(1,2),
                diffusion.random = 0, 
                drift.param = matrix(c(0.5,1.8,0.25,0.25,1,2,0.25,0.25),nrow=2,byrow=FALSE), 
                diffusion.param = 0.1, nb.mixt = 2, mixt.prop = c(0.5,0.5))

# -- Estimation without validation
res <- msde.fit(times = sim$times, X = sim$X, model = 'OU', drift.random = c(1,2),
                nb.mixt=2, Niter = 10)

summary(res)
plot(res)

# -- Estimation with prediction
res.valid <- msde.fit(times = sim$times, X = sim$X, model = 'OU', drift.random = c(1,2),
                      nb.mixt=2, Niter = 10, valid = 1)

summary(res.valid)
plot(res.valid)

# Example 3 : CIR with one random effect in the drift and one random effect in the diffusion 
# coefficient

sim <- msde.sim(M = 100, T = 5, N = 5000, model = 'CIR', drift.random = 2,
                diffusion.random = 1, drift.param = c(4,1,0.1), diffusion.param = c(8,0.5),
                X0 = 1)

res <- msde.fit(times = sim$times, X = sim$X, model = 'CIR', drift.random = 2,
                diffusion.random = 1)

summary(res)

# Further examples can be found in the section dedicated to neuronal.data.
  }

}
\references{
See  

\bold{[1]} Maximum Likelihood Estimation for Stochastic Differential Equations with Random Effects, Delattre, M., Genon-Catalot, V. and Samson, A. \emph{Scandinavian Journal of Statistics 40(2) 2012} \bold{322-343} 

\bold{[2]} Estimation of population parameters in stochastic differential equations with random effects in the diffusion coefficient, Delattre, M., Genon-Catalot, V. and Samson, A. \emph{ESAIM:PS 19 2015} \bold{671-688}

\bold{[3]} Mixtures of stochastic differential equations with random effects: application to data clustering, Delattre, M., Genon-Catalot, V. and Samson, A. \emph{Journal of Statistical Planning and Inference 173 2016} \bold{109-124} 

\bold{[4]} Parametric inference for discrete observations of diffusion processes with mixed effects, Delattre, M., Genon-Catalot, V. and Laredo, C. \emph{hal-01332630 2016}

\bold{[5]} Estimation of the joint distribution of random effects for a discretely observed diffusion with random effects, Delattre, M., Genon-Catalot, V. and Laredo, C. \emph{hal-01446063 2017}
}
\author{
Maud Delattre and Charlotte Dion
}
