\name{getSavedata_Fileinfo}
\alias{getSavedata_Fileinfo}
\title{Read Variable Names, Formats, and Widths from data generated by the SAVEDATA Command}
\usage{
  getSavedata_Fileinfo(outfile)
}
\arguments{
  \item{outfile}{required. The name of the Mplus output
  file to read. Can be an absolute or relative path.  If
  \code{outfile} is a relative path or just the filename,
  then it is assumed that the file resides in the working
  directory \code{getwd()}.}
}
\value{
  Returns a list of SAVEDATA file information that
  includes: \item{fileName}{The name of the file containing
  the analysis dataset created by the Mplus SAVEDATA
  command.} \item{fileVarNames}{A character vector
  containing the names of variables in the dataset.}
  \item{fileVarFormats}{A character vector containing the
  Fortran-style formats of variables in the dataset.}
  \item{fileVarWidths}{A numeric vector containing the
  widths of variables in the dataset (which is stored in
  fixed-width format).} \item{bayesFile}{The name of the
  BPARAMETERS file containing draws from the posterior
  distribution created by the Mplus SAVEDATA BPARAMETERS
  command.} \item{bayesVarNames}{A character vector
  containing the names of variables in the BPARAMETERS
  dataset.} \item{tech3File}{A character vector of the tech
  3 output.} \item{tech4File}{A character vector of the
  tech 4 output.}
}
\description{
  This function reads the SAVEDATA INFORMATION section from
  an Mplus output file that used the SAVEDATA command, and
  it returns a list with the filename, variable names,
  variable formats, and variable widths of the SAVEDATA
  file. If present, the function also parses information
  about the Bayesian Parameters (BPARAMETERS) file.
}
\examples{
\dontrun{
  fileInfo <- getSavedata_Fileinfo("C:/Program Files/Mplus/Test Output.out")
}
}
\author{
  Michael Hallquist
}
\seealso{
  \code{\link{getSavedata_Data}}
}
\keyword{interface}

